// CardFront.cpp : implementation file
//

#include "stdafx.h"
#include "Ultima_C++Demo.h"
#include "PrintDemo.h"
#include "CardFront.h"
#include "afxdialogex.h"

//#############################################################################

// CCardFront dialog
IMPLEMENT_DYNAMIC(CCardFront, CDialog)

CCardFront::CCardFront(CWnd* pParent /*=NULL*/)
	: CDialog(CCardFront::IDD, pParent)
{
}

CCardFront::~CCardFront()
{
}

void CCardFront::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_FRONT_TEXT, Text);
	DDX_Control(pDX, IDC_FRONT_TEXT_COLOUR, TextColour);
	DDX_Control(pDX, IDC_FRONT_TEXT_SIZE, TextSize);
	DDX_Control(pDX, IDC_FRONT_TEXT_SIZE_SPIN, TextSize_Spin);
	DDX_Control(pDX, IDC_FRONT_TEXT_BOLD, TextBold);
	DDX_Control(pDX, IDC_FRONT_TEXT_ITALIC, TextItalic);
	DDX_Control(pDX, IDC_FRONT_TEXT_UNDERLINE, TextUnderline);
	DDX_Control(pDX, IDC_FRONT_TEXT_STRIKE, TextStrikeout);
	DDX_Control(pDX, IDC_FRONT_TEXT_X, TextX);
	DDX_Control(pDX, IDC_FRONT_TEXT_Y, TextY);
	DDX_Control(pDX, IDC_FRONT_TEXT_RESIN, TextResin);

	DDX_Control(pDX, IDC_FRONT_SHAPE, Shape);
	DDX_Control(pDX, IDC_FRONT_SHAPE_PEN, ShapePen);
	DDX_Control(pDX, IDC_FRONT_SHAPE_PEN_WIDTH, ShapePenWidth);
	DDX_Control(pDX, IDC_FRONT_SHAPE_PEN_WIDTH_SPIN, ShapePen_Spin);
	DDX_Control(pDX, IDC_FRONT_SHAPE_BRUSH, ShapeBrush);
	DDX_Control(pDX, IDC_FRONT_SHAPE_LEFT, ShapeLeft);
	DDX_Control(pDX, IDC_FRONT_SHAPE_TOP, ShapeTop);
	DDX_Control(pDX, IDC_FRONT_SHAPE_RIGHT, ShapeRight);
	DDX_Control(pDX, IDC_FRONT_SHAPE_BOTTOM, ShapeBottom);
	DDX_Control(pDX, IDC_FRONT_SHAPE_RESIN, ShapeResin);

	DDX_Control(pDX, IDC_FRONT_LINE_COLOUR, LineColour);
	DDX_Control(pDX, IDC_FRONT_LINE_WIDTH, LineWidth);
	DDX_Control(pDX, IDC_FRONT_LINE_WIDTH_SPIN, LineSpin);
	DDX_Control(pDX, IDC_FRONT_LINE_START_X, LineStartX);
	DDX_Control(pDX, IDC_FRONT_LINE_START_Y, LineStartY);
	DDX_Control(pDX, IDC_FRONT_LINE_END_X, LineEndX);
	DDX_Control(pDX, IDC_FRONT_LINE_END_Y, LineEndY);
	DDX_Control(pDX, IDC_FRONT_LINE_RESIN, LineResin);

	DDX_Control(pDX, IDC_FRONT_IMAGE_LEFT, ImageLeft);
	DDX_Control(pDX, IDC_FRONT_IMAGE_TOP, ImageTop);
	DDX_Control(pDX, IDC_FRONT_IMAGE_P1, ImageP1);
	DDX_Control(pDX, IDC_FRONT_IMAGE_P2, ImageP2);
	DDX_Control(pDX, IDC_FRONT_IMAGE_FILENAME, ImageFilename);
	DDX_Control(pDX, IDC_FRONT_IMAGE_FILENAME_BTN, ImageFilenameBtn);
	DDX_Control(pDX, IDC_FRONT_IMAGE_RESIN, ImageResin);

	DDX_Control(pDX, IDC_FRONT_MAG1TEXT, Mag1Data);
	DDX_Control(pDX, IDC_FRONT_MAG2TEXT, Mag2Data);
	DDX_Control(pDX, IDC_FRONT_MAG3TEXT, Mag3Data);
	DDX_Control(pDX, IDC_FRONT_TEXT_ENABLED, TextEnabled);
	DDX_Control(pDX, IDC_FRONT_SHAPE_ENABLED, ShapeEnabled);
	DDX_Control(pDX, IDC_FRONT_LINE_ENABLED, LineEnabled);
	DDX_Control(pDX, IDC_FRONT_IMAGE_ENABLED, ImageEnabled);
	DDX_Control(pDX, IDC_FRONT_MAG_ENABLED, MagDataEnabled);
}

BEGIN_MESSAGE_MAP(CCardFront, CDialog)
	ON_BN_CLICKED(IDC_FRONT_IMAGE_FILENAME_BTN, &CCardFront::OnBnClickedFilename)
END_MESSAGE_MAP()

//****************************************************************************

// CCardFront message handlers

BOOL CCardFront::OnInitDialog()
{
	CDialog::OnInitDialog();

	for (int i = 0; i < CPrintDemo::MaxColours; i++)
	{
		TextColour.AddString(CPrintDemo::ColourTable[i].Text);
		ShapePen.AddString(CPrintDemo::ColourTable[i].Text);
		ShapeBrush.AddString(CPrintDemo::ColourTable[i].Text);
		LineColour.AddString(CPrintDemo::ColourTable[i].Text);
	}

	//===== Front Text =====
#ifdef _M_X64
	Text.SetWindowText(_T("Front - First Line of C++ Text (64 bit)"));
#else
	Text.SetWindowText(_T("Front - First Line of C++ Text (32 bit)"));
#endif
	TextSize.SetWindowText(_T("10"));
	TextSize_Spin.SetRange(1, 20);
	TextColour.SetCurSel(0);
	TextX.SetWindowText(_T("10"));
	TextY.SetWindowText(_T("50"));
	TextEnabled.SetCheck(TRUE);
	TextResin.SetCheck(TRUE);

	//===== Front Shape =====
	for (int i = 0; i < CPrintDemo::MaxShapes; i++)
	{
		Shape.AddString(CPrintDemo::ShapeTable[i].Text);
	}
	Shape.SetCurSel(0);
	ShapePen.SetCurSel(0);
	ShapePenWidth.SetWindowText(_T("5"));
	ShapePen_Spin.SetRange(5, 50);
	ShapeBrush.AddString(_T("Transparent"));
	ShapeBrush.SetCurSel(CPrintDemo::MaxColours);
	ShapeLeft.SetWindowText(_T("60"));
	ShapeTop.SetWindowText(_T("160"));
	ShapeRight.SetWindowText(_T("320"));
	ShapeBottom.SetWindowText(_T("320"));
	ShapeEnabled.SetCheck(TRUE);

	//===== Front Line =====
	LineColour.SetCurSel(0);
	LineWidth.SetWindowText(_T("8"));
	LineSpin.SetRange(1, 20);
	LineStartX.SetWindowText(_T("10"));
	LineStartY.SetWindowText(_T("10"));
	LineEndX.SetWindowText(_T("800"));
	LineEndY.SetWindowText(_T("150"));
	LineEnabled.SetCheck(TRUE);

	//===== Front Image =====
	ImageLeft.SetWindowText(_T("50"));
	ImageTop.SetWindowText(_T("110"));
	ImageP1.SetWindowText(_T("0"));
	ImageP2.SetWindowText(_T("0"));
	ImageFilename.SetWindowText(_T(""));

	//===== Front Magnetic Data =====
	Mag1Data.SetWindowText(_T(""));
	Mag2Data.SetWindowText(_T(""));
	Mag3Data.SetWindowText(_T(""));

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

void CCardFront::EnableGetSetControls
(
	BOOL bControl
)
{
	Text.EnableWindow(bControl);
	TextEnabled.EnableWindow(bControl);
	TextColour.EnableWindow(bControl);
	TextSize.EnableWindow(bControl);
	TextBold.EnableWindow(bControl);
	TextItalic.EnableWindow(bControl);
	TextUnderline.EnableWindow(bControl);
	TextStrikeout.EnableWindow(bControl);
	TextX.EnableWindow(bControl);
	TextY.EnableWindow(bControl);
	TextResin.EnableWindow(bControl);

	Shape.EnableWindow(bControl);
	ShapeEnabled.EnableWindow(bControl);
	ShapePen.EnableWindow(bControl);
	ShapePenWidth.EnableWindow(bControl);
	ShapeBrush.EnableWindow(bControl);
	ShapeLeft.EnableWindow(bControl);
	ShapeTop.EnableWindow(bControl);
	ShapeRight.EnableWindow(bControl);
	ShapeBottom.EnableWindow(bControl);
	ShapeResin.EnableWindow(bControl);

	LineEnabled.EnableWindow(bControl);
	LineColour.EnableWindow(bControl);
	LineWidth.EnableWindow(bControl);
	LineStartX.EnableWindow(bControl);
	LineStartY.EnableWindow(bControl);
	LineEndX.EnableWindow(bControl);
	LineEndY.EnableWindow(bControl);
	LineResin.EnableWindow(bControl);

	ImageEnabled.EnableWindow(bControl);
	ImageLeft.EnableWindow(bControl);
	ImageTop.EnableWindow(bControl);
	ImageP1.EnableWindow(bControl);
	ImageP2.EnableWindow(bControl);
	ImageFilename.EnableWindow(bControl);
	ImageFilenameBtn.EnableWindow(bControl);
	ImageResin.EnableWindow(bControl);

	MagDataEnabled.EnableWindow(bControl);
	Mag1Data.EnableWindow(bControl);
	Mag2Data.EnableWindow(bControl);
	Mag3Data.EnableWindow(bControl);
}

//****************************************************************************

void CCardFront::OnBnClickedFilename()
{
	static TCHAR szFilter[] = _T("Images (*.bmp;*.jpg;*.png;*.tif)|*.bmp; *.jpg; *.png; *.tif||");

	CFileDialog fOpenDlg(TRUE, NULL, NULL, OFN_FILEMUSTEXIST, szFilter, this);

	if (fOpenDlg.DoModal() == IDOK)
	{
		Image = fOpenDlg.GetPathName();
		ImageFilename.SetWindowText(fOpenDlg.GetFileName());
	}
}
